/* 
 * Copyright (c) 1994-1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL or COMMERCIAL purposes and
 * without fee is hereby granted.
 * Please refer to the file http://java.sun.com/copy_trademarks.html
 * for further important copyright and trademark information and to
 * http://java.sun.com/licensing.html for further important licensing
 * information for the Java (tm) Technology.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
 * CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE
 * PERFORMANCE, SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT
 * NAVIGATION OR COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE
 * SUPPORT MACHINES, OR WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE
 * SOFTWARE COULD LEAD DIRECTLY TO DEATH, PERSONAL INJURY, OR SEVERE
 * PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH RISK ACTIVITIES").  SUN
 * SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTY OF FITNESS FOR
 * HIGH RISK ACTIVITIES.
 */

import java.lang.*; 
import java.io.InputStream;
import java.awt.*;
import java.net.*;
import java.util.*;
 
/**
 * A image loop applet, first raise smiles and then drop them
 *
 * @author      Siebe R. Brouwer
 * version      1.1, 29 September 1995
 */

// class Display, display prints the empty diagram to the screen 
class Display extends Panel {
    
    protected String header;
    protected String yText;
    protected String xText;
    protected int xTop;
    protected int yTop;
    protected int xGap;
    protected int yGap;
    protected int xStart;
    protected int yStart;
    protected Diagram diagram;
    protected int moved;
    protected Scrollbar scrollbar;

    //constructor
    Display(String h, String xT, String yT, int xC,int yC) {
	header = h;
	xStart = 50;
	xGap= xC;
	yGap= yC;
	yText = yT;
	xText = xT;
    	moved = 0;
        setLayout(new BorderLayout());
	scrollbar = new Scrollbar(0);
	scrollbar.setValues(0, 50,-1000,1000);
	add("South",scrollbar);
    }
    
    // draw a new diagram
    public void drawDiagram(Diagram d) {
	diagram = d;
	repaint();
    }
    
    // overwrite the paint method
    public void paint(Graphics g) {
	moved = scrollbar.getValue() * -1;
	int gaps = getCaps(moved);
	int left = getLeft(gaps, moved);
	yStart = yStart();
	xTop = xTop();
	yTop = yTop();
	scrollbar.reshape(xStart, yStart +40, xTop - xStart, 15);
	drawAxiss(g, left);
	g.drawString(header, xStart, 40);
	g.drawString(xText, xTop - 100, yStart +30);
	g.drawString(yText, 10, yTop - 15);
	diagram.drawData(g, gaps, left, moved);
    }    
    
    /* draw the x-axis and y-axis to the screen
     * including the markers on the axis.
     */
       protected void drawAxiss(Graphics g, int left) {
	yStart = yStart();
 	g.drawLine(xStart, yStart, xTop, yStart);
	g.drawLine(xStart, yStart, xStart, yTop);
	int j=((left <0)?xGap+left:left);
	for(int i = j+xStart; i <= xTop; i += xGap) {
	    g.drawLine(i, yStart, i, yStart + 5);
	}
	for(int i = yStart; i >= yTop; i -= yGap) {
	    g.drawLine(xStart, i, xStart-5, i);
	}
    }
    
    // if the scrollbar has been used than repaint.
    public boolean handleEvent(Event evt) {
	switch(evt.id) {
	  case Event.SCROLL_ABSOLUTE:
	    repaint();
	    return true;
	  case Event.SCROLL_LINE_DOWN:
	    repaint();
	    return true;
          case Event.SCROLL_LINE_UP:
	    repaint();
	    return true;
	  case Event.SCROLL_PAGE_UP:
	    repaint();
	    return true;
	  case Event.SCROLL_PAGE_DOWN:	
	    repaint();
	    return true;
	} 	
	return false;
    }
    
    // return the number of gaps that are in the moved
    protected int getCaps(int moved) {
    	if(moved > xGap|| moved < (xGap* -1)) {
	    return moved / xGap;
	}	
	
	return 0;
    }		
    
    // return whats left between number of Gaps and moved 
    protected int getLeft(int gaps, int moved) {
    	return (moved - (gaps * xGap));
    } 
    
    // set the scrollbar to the desired values
    public void setScrollbar(int value, int visible,int min, int max) {
    	scrollbar.setValues(value, visible, min, max);
    }
    
    // return xGap
    public int xGap() {
    	return xGap;
    }
    
    // return yGap
    public int yGap() {
    	return yGap;
    }
    	
    // return the xStart
    public int xStart() {
	return xStart;
    }
    
    // return yStart
    public int yStart() {
	return size().height - 70;
    }
    
    // return yTop
    public int yTop() {
    	return 100;
    }
    
    // return xTop
    public int xTop() {
	return size().width - 50;
    }
}


/* Abstract class Diagram, all diagrams used by Display have as parrent 
 * this class.
 */
abstract class Diagram {
    
    protected Display display; 
    abstract void drawData(Graphics g,int Gaps, int left, int moved);
}
    





