
import java.applet.*;
import java.net.*;
import java.awt.*;

/**
 * A simple Link button.
 *
 * @author Arthur van Hoff
 */
public class LinkButton extends Applet {
    URL url;
    AudioClip snd;

    public void init() {
	String lbl = getParameter("lbl");
	if (lbl == null) {
	    lbl = "link";
	}
	try {
	    String str = getParameter("href");
	    if (str != null) {
		url = new URL(getDocumentBase(), str);
	    }
	} catch (MalformedURLException e) {
	}

	setFont(new Font("Helvetica", Font.BOLD, 14));
	setLayout(new BorderLayout());
	add("Center", new Button(lbl));

	lbl = getParameter("snd");
	if (lbl != null) {
	    snd = getAudioClip(getDocumentBase(), lbl);
	}
    }
    public boolean action(Event evt, Object arg) {
	if (snd != null) {
	    snd.play();
	}
	if (url != null) {
	    System.out.println("GOTO: " + url);
	    getAppletContext().showDocument(url);
	}
	return true;
    }	
}
