package r08.r08_05;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OtherTransformations {
    public static <T> void show(String title, Stream<T> stream) {
        final int SIZE = 10;
        List<T> firstElements = stream.limit(SIZE + 1).collect(Collectors.toList());
        System.out.print(title + ": ");
        if (firstElements.size() <= SIZE)
            System.out.println(firstElements);
        else {
            firstElements.remove(SIZE);
            String out = firstElements.toString();
            System.out.println(out.substring(0, out.length() - 1) + ", ...]");
        }
    }

    public static void main(String[] args) throws IOException {
        Stream<String> unikalneSowa = Stream.of("wesoo", "wesoo", "wesoo", "delikatnie")
                .distinct();
        show("unikalneSowa", unikalneSowa);

        String contents = new String(Files.readAllBytes(Paths.get("zemsta.txt")),
                StandardCharsets.UTF_8);
        List<String> sowa = Arrays.asList(contents.split("\\PL+"));
        show("sowa", sowa.stream());

        Stream<String> rne =  sowa.stream().distinct();
        show("rne", rne);

        Stream<String> posortowane =  sowa.stream().sorted();
        show("posortowane", posortowane);

        Stream<String> rneSortowane =  sowa.stream().distinct().sorted();
        show("rneSortowane", rneSortowane);

        Stream<String> najduszeNajpierw =  sowa.stream().sorted(Comparator.comparing(String::length).reversed());
        show("najduszeNajpierw", najduszeNajpierw);
        
        Object[] potgi = Stream.iterate(1.0, p -> p * 2)
                .peek(e -> System.out.println("Pobieranie " + e)).limit(20).toArray();
        System.out.println(Arrays.asList(potgi));
    }
}
