package r10.r10_08;

public class ThreadDemo {
    public static void main(String[] args) throws InterruptedException {
        Runnable zadanie = () -> { for (int i = 1; i <= 100; i++) System.out.print(i + " ");  };
        var wątek = new Thread(zadanie); 
        wątek.start();
        System.out.println("Wątek uruchomiony.");
        wątek.join();
        System.out.println("\nWątek dołączony.");
        
        Runnable interruptibleTask = () -> {
            System.out.print("\nPrzerywalne: ");
            try {
                for (int i = 1; i <= 100; i++) {
                    System.out.print(i + " ");
                    Thread.sleep(100);
                }
            }
            catch (InterruptedException ex) {
                System.out.println("Przerwany!");
            }
        };
        
        wątek = new Thread(interruptibleTask);
        wątek.start();
        Thread.sleep(1000);
        wątek.interrupt();         
        
        Runnable exceptionalTask = () -> {
            System.out.print("\nWyjątkowe: ");
            for (int i = 1; i <= 100; i++) {
                System.out.print(i + " ");
                if (i == 40) throw new IllegalStateException();
            }            
        };
        wątek = new Thread(exceptionalTask);
        wątek.setUncaughtExceptionHandler((t, ex) -> System.out.println("Koniec!"));
        wątek.start();
        wątek.join();
        
        Runnable daemonTask = () -> {
            System.out.print("\nDaemon: ");
            for (int i = 1; i <= 100; i++) {
                System.out.print(i + " ");
                // if (i == 42) Thread.currentThread().setDaemon(true);
            }            
        };
        wątek = new Thread(daemonTask);
        wątek.setDaemon(true);
        wątek.start();        
        System.out.println("\nŻegnaj daemon!");
    }    
}
