package r08.r08_08;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollectingResults {
    public static Stream<String> noVowels(String filename) throws IOException {
        String contents = Files.readString(Path.of(filename));
        List<String> wordList = List.of(contents.split("\\PL+"));
        Stream<String> words = wordList.stream();
        return words.map(s -> s.replaceAll("[aeiouyąęóAEIOUYĄĘÓ]", ""));
    }

    public static <T> void show(String label, Set<T> set) {
        System.out.print(label + ": " + set.getClass().getName());
        System.out.println("["
                + set.stream().limit(10).map(Object::toString).collect(Collectors.joining(", "))
                + "]");
    }

    public static void main(String[] args) throws IOException {
        Iterator<Integer> iter = Stream.iterate(0, n -> n + 1).limit(10).iterator();
        while (iter.hasNext())
            System.out.println(iter.next());

        Object[] numbers = Stream.iterate(0, n -> n + 1).limit(10).toArray();
        System.out.println(numbers); // Zauważ, że jest to tablica Object[].

        try {
            var number = (Integer) numbers[0]; // OK
            System.out.println("liczba: " + number);
            var numbers2 = (Integer[]) numbers; // Wyrzuca wyjątek.
        } catch (ClassCastException ex) {
            ex.printStackTrace();
        }

        Integer[] numbers3 = Stream.iterate(0, n -> n + 1).limit(10).toArray(Integer[]::new);
        System.out.println(numbers3); // Zauważ, że jest to tablica Integer[].

        HashSet<String> noVowelHashSet = noVowels("zemsta.txt").collect(HashSet::new, HashSet::add,
                HashSet::addAll);
        show("noVowelHashSet", noVowelHashSet);

        Set<String> noVowelSet = noVowels("zemsta.txt").collect(Collectors.toSet());
        show("noVowelSet", noVowelSet);

        TreeSet<String> noVowelTreeSet = noVowels("zemsta.txt").collect(
                Collectors.toCollection(TreeSet::new));
        show("noVowelTreeSet", noVowelTreeSet);

        String wynik = noVowels("zemsta.txt").limit(10).collect(Collectors.joining());
        System.out.println(wynik);
        wynik = noVowels("zemsta.txt").limit(10).collect(Collectors.joining(", "));
        System.out.println(wynik);

        IntSummaryStatistics summary = noVowels("zemsta.txt").collect(
                Collectors.summarizingInt(String::length));
        double średniaDługośćSłowa = summary.getAverage();
        double maksymalnaDługośćSłowa = summary.getMax();
        System.out.println("Średnia długość słowa: " + średniaDługośćSłowa);
        System.out.println("Maksymalna długość słowa: " + maksymalnaDługośćSłowa);

        noVowels("zemsta.txt").limit(10).forEach(System.out::println);
    }
}
