package r04.r04_02;

/*

Skompiluj i uruchom poleceniami

javac --enable-preview --release 17 -encoding UTF-8 r04/r04_02/SealedDemo.java
java --enable-preview r04.r04_02.SealedDemo 
 
*/

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

sealed interface JSONValue permits JSONArray, JSONObject, JSONPrimitive {
	public default String type() {
		return switch (this) {
			case JSONArray j -> "array";
		    case JSONNumber j -> "number";
		    case JSONString j -> "string";
		    case JSONBoolean j -> "boolean";
		    case JSONObject j -> "object"; 
		    case JSONNull j -> "null";
		    // Nie potrzeba tu klauzuli default.
		};
    }
}

final class JSONArray extends ArrayList<JSONValue> implements JSONValue {
}

final class JSONObject extends HashMap<String, JSONValue> implements JSONValue {
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append("{");
		for (Map.Entry<String, JSONValue> entry : entrySet()) {
			if (result.length() > 1)
				result.append(",");
			result.append(" \"");
			result.append(entry.getKey());
			result.append("\": ");
			result.append(entry.getValue());
		}
		result.append(" }");
		return result.toString();
	}
}

sealed interface JSONPrimitive extends JSONValue permits JSONNumber, JSONString, JSONBoolean, JSONNull {
}

final record JSONNumber(double value) implements JSONPrimitive {
	public String toString() {
		return "" + value;
	}
}

final record JSONString(String value) implements JSONPrimitive {
	public String toString() {
		return "\"" + value.translateEscapes() + "\"";
	}
}

enum JSONBoolean implements JSONPrimitive {
	FALSE, TRUE;

	public String toString() { return super.toString().toLowerCase(); }
}

enum JSONNull implements JSONPrimitive {
	INSTANCE;

	public String toString() { return "null"; }
}

public class SealedDemo {
	public static void main(String[] args) {
		JSONObject obj = new JSONObject();
		obj.put("imię", new JSONString("Henryk"));
		obj.put("wynagrodzenie", new JSONNumber(90000));
		obj.put("żonaty/zamężna", JSONBoolean.FALSE);
		JSONArray arr = new JSONArray();
		arr.add(new JSONNumber(13));
		arr.add(JSONNull.INSTANCE);

		obj.put("ulubioneLiczby", arr);
		System.out.println(obj);
		System.out.println(obj.type());
	}
}
