package r09.r09_04;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Flags {
    public static void main(String[] args) {
        showMatches("[AO\u0144]", Pattern.CASE_INSENSITIVE, "Poznań");
        showMatches("[AO\u0144]", Pattern.CASE_INSENSITIVE | Pattern.UNICODE_CHARACTER_CLASS, "Poznań");
        showMatches("^[a-z ]+$", Pattern.MULTILINE, "jeszcze raz\njeszcze raz\nniech żyje\rżyje nam\n");
        showMatches("^[a-z ]+$", Pattern.MULTILINE | Pattern.UNIX_LINES, "jeszcze raz\njeszcze raz\nniech żyje\rżyje nam\n");
        showMatches(".", 0, "100 lat\n100 lat");
        showMatches(".", Pattern.DOTALL, "100 lat\n100 lat");
        showMatches(".# Co za wzorzec!", Pattern.COMMENTS, "Witaj");
        showMatches(".", Pattern.LITERAL, "Witaj. Świecie.");
        showMatches("\u0144", 0, "Poznan\u0301");
        showMatches("\u0144", Pattern.CANON_EQ, "Poznan\u0301");
    }
    
    public static void showMatches(String regex, int flags, String input) {
        Pattern pattern = Pattern.compile(regex, flags);
        Matcher matcher = pattern.matcher(input);
        System.out.printf("%-30s%-30s", regex, input);
        while (matcher.find()) {
            String match = matcher.group();
            System.out.print(match + " ");
        }
        System.out.println();        
    }
}
