package r01.r01_05;

import java.time.ZoneId;
import java.util.Arrays;

public class StringDemo {
    public static void main(String[] args) {
        String location = "Java";
        String greeting = "Witaj, " + location;
        System.out.println(greeting);
        int age = 42;
        String output = age + " lata";
        System.out.println(output);
        
        System.out.println("Za rok będziesz miał  " + age + 1); // Błąd
        System.out.println("Za rok będziesz miał " + (age + 1)); // Poprawnie
        
        String names = String.join(", ", "Piotr", "Paweł", "Maria");
        System.out.println(names);
        
        // Klasa StringBuilder
        
        var builder = new StringBuilder();
        for (String id : ZoneId.getAvailableZoneIds()) {
            builder.append(id);
            builder.append(", ");
        }
        String result = builder.toString();
        System.out.println(result.substring(0, 200) + "...");
        System.out.println(result.length());
        
        // Wycinanie ciągów znaków
        
        greeting = "Witaj, Świecie!";
        location = greeting.substring(7, 14);
        System.out.println(location);
        
        // Porównywanie ciągów znaków
        
        System.out.println(location.equals("Świat"));
        System.out.println(location == "Świat");
        System.out.println(location.equalsIgnoreCase("świat"));
        System.out.println("świt".compareTo("świat"));

        // Konwersja liczb na znaki i znaków na liczby
        int n = 42;
        String str = Integer.toString(n, 2);
        System.out.println(str);
        
        n = Integer.parseInt(str);
        System.out.println(n);
        n = Integer.parseInt(str, 2);
        System.out.println(n);
        double x = Double.parseDouble("3.14"); 
        System.out.println(x);
        
        System.out.println(greeting.toUpperCase());
        System.out.println(greeting); // zawartość zmiennej greeting nie zmieniła się
        
        // Unicode
        String javatm = "Java\u2122";
        System.out.println(javatm);
        System.out.println(Arrays.toString(javatm.codePoints().toArray()));
        System.out.println(javatm.length());
        
        String octonions = "\ud835\udd46";
        System.out.println(octonions);
        System.out.println(Arrays.toString(octonions.codePoints().toArray()));
        System.out.println(octonions.length()); 
        // Zlicza jednostki kodowe (code units), a nie punkty kodowe (code points) z Unicode 
    }
}
