package r08.r08_02;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class CreatingStreams {
    public static <T> void show(String title, Stream<T> stream) {
        final int SIZE = 10;
        List<T> firstElements = stream.limit(SIZE + 1).toList();
        System.out.print(title + ": ");
        if (firstElements.size() <= SIZE)
            System.out.println(firstElements);
        else {
            firstElements.remove(SIZE);
            String out = firstElements.toString();
            System.out.println(out.substring(0, out.length() - 1) + ", ...]");
        }
    }

    public static void main(String[] args) throws IOException {
        Path path = Path.of("zemsta.txt");
        String contents = Files.readString(path);

        Stream<String> słowa = Stream.of(contents.split("\\PL+"));
        show("słowa", słowa);
        Stream<String> piosenka = Stream.of("gdzie", "strumyk", "płynie", "z", "wolna");
        show("piosenka", piosenka);
        Stream<String> silence = Stream.empty();
        show("cisza", silence);

        Stream<String> powtórki = Stream.generate(() -> "Echo");
        show("powtórki", powtórki);

        Stream<Double> losowe = Stream.generate(Math::random);
        show("losowe", losowe);

        Stream<BigInteger> integers = Stream.iterate(BigInteger.ONE, n -> n.add(BigInteger.ONE));
        show("liczby całkowite", integers);

        var limit = new BigInteger("7");
        integers = Stream.iterate(BigInteger.ZERO,
            n -> n.compareTo(limit) < 0,
            n -> n.add(BigInteger.ONE));
        show("liczby całkowite", integers);
        
        Stream<String> słowaInnymSposobem = Pattern.compile("\\PL+").splitAsStream(contents);
        show("słowa innym sposobem", słowaInnymSposobem);

        try (Stream<String> wiersze = Files.lines(path)) {
            show("wiersze", wiersze);
        }
    }
}
