package com.horstmann.places;

/**

javac -p mods/jakarta.json.bind-api-2.0.0.jar \
    r15.r15_06/module-info.java \
    r15.r15_06/com/horstmann/places/Demo.java \
    r15.r15_06/com/horstmann/places/Country.java

java -p mods/jakarta.json-api-2.0.1.jar:\
mods/jakarta.json.bind-api-2.0.0.jar:\
mods/jakarta.json-2.0.1-module.jar:\
mods/yasson-2.0.3.jar:r15.r15_06 \
    -m r15.r15_06/com.horstmann.places.Demo

(w systemie Windows zamiast : musi być ;)
*/

import jakarta.json.bind.*;
import jakarta.json.bind.config.*;
import java.lang.reflect.*;

public class Demo {
    public static void main(String[] args) {
        var belgium = new Country("Belgia", 30510);
        var config = new JsonbConfig()
            .withPropertyVisibilityStrategy(
                new PropertyVisibilityStrategy() {
                    public boolean isVisible(Field field) { return true; }
                    public boolean isVisible(Method method) { return false; }
                });
        Jsonb jsonb = JsonbBuilder.create(config);
        String json = jsonb.toJson(belgium);
        System.out.println(json);
    }
}
