package r10.r10_07;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class KolejkaDemo {
    public static Kolejka kolejka = new Kolejka();
    public static Set<Object> set = ConcurrentHashMap.newKeySet();

    public static void main(String[] args) throws InterruptedException {
        ExecutorService executor = Executors.newCachedThreadPool();
        for (int i = 1; i <= 100; i++) {
            int taskId = i;
            executor.execute(() -> {
                for (int k = 1; k <= 1000; k++) 
                    kolejka.dodaj(taskId * 1000 + k);
            });
            executor.execute(() -> {
                for (int k = 1; k <= 1000; k++) 
                    try {
                        set.add(kolejka.pobierz());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
            });
        }
        executor.shutdown();
        executor.awaitTermination(10, TimeUnit.MINUTES);
        System.out.println("Końcowy rozmiar: " + set.size());
    }
}
