package r10.r10_01;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CallableDemo {
    public static long occurrences(String word, Path path) {
        try {
            String zawartość = Files.readString(path);
            return Pattern.compile("\\PL+")
                    .splitAsStream(zawartość)
                    .filter(Predicate.isEqual(word))
                    .count();
        } catch (IOException ex) {
            return 0;
        }
    }
    
    public static Set<Path> descendants(Path p) throws IOException {        
        try (Stream<Path> entries = Files.walk(p)) {
            return entries.collect(Collectors.toSet());
        }
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException, IOException {
        String word = "String";
        Set<Path> ścieżki = descendants(Path.of("."));
        var zadania = new ArrayList<Callable<Long>>();
        for (Path p : ścieżki) zadania.add(
            () -> { return occurrences(word, p); });
        int processors = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(processors);
        List<Future<Long>> futures = executor.invokeAll(zadania);
        long suma = 0;
        for (Future<Long> f : futures) suma += f.get();
        System.out.println("Wystąpień słowa String: " + suma);
        
        String searchWord = "wystąpienia";
        var searchTasks = new ArrayList<Callable<Path>>();
        for (Path p : ścieżki) searchTasks.add(
            () -> { if (occurrences(searchWord, p) > 0) return p; else throw new RuntimeException(); });
        Path znalezione = executor.invokeAny(searchTasks);
        System.out.println(znalezione);
        executor.shutdown();
    }
}
