package r08.r08_03;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class FilterMapDemo {
    public static <T> void show(String title, Stream<T> stream) {
        final int SIZE = 10;
        List<T> firstElements = stream.limit(SIZE + 1).toList();
        System.out.print(title + ": ");
        if (firstElements.size() <= SIZE)
            System.out.println(firstElements);
        else {
            firstElements.remove(SIZE);
            String out = firstElements.toString();
            System.out.println(out.substring(0, out.length() - 1) + ", ...]");
        }
    }

    public static Stream<String> punktyKodowe(String s) {
        return s.codePoints().mapToObj(cp -> new String(new int [] { cp }, 0, 1));
    }

    public static void main(String[] args) throws IOException {
        String contents = Files.readString(Path.of("zemsta.txt"));
        List<String> słowa = List.of(contents.split("\\PL+"));
        Stream<String> długieSłowa = słowa.stream().filter(w -> w.length() > 12);
        show("długieSłowa", długieSłowa);

        Stream<String> małeLitery = słowa.stream().map(String::toLowerCase);
        show("małeLitery", małeLitery);

        String[] song = { "gdzie", "strumyk", "płynie", "z", "wolna", "rozsiewa", "zioła",
                "maj" };
        Stream<String> pierwszeLitery = Stream.of(song).filter(w -> w.length() > 0).map(s -> s.substring(0, 1));
        show("pierwszeLitery", pierwszeLitery);

        Stream<String> letters = Stream.of(song).flatMap(w -> punktyKodowe(w));
        show("litery", letters);
        
        Stream<String> wynik = słowa.stream().mapMulti((s, collector) -> {
            int i = 0;
            while (i < s.length()) {
                int cp = s.codePointAt(i);
                collector.accept(new String(new int [] { cp }, 0, 1));
                i += Character.charCount(cp);
            }
        });
        show("wynik", wynik);
    }
}
