package regex;

/**
 * 
 * Ten program testuje dopasowanie wyrażeń regularnych. Wprowadź wzorzec i łańcuch znaków 
 * do dopasowania lub naciśnij Enter, aby zakończyć. Jeśli wzorzec zawiera grupy, 
 * po dopasowaniu zostaną wyświetlone ich granice.
 * 
 * @version 1.03 2018-05-01
 * @author Cay Horstmann
 */

import java.util.*;
import java.util.regex.*;

public class RegexTest
{
   public static void main(String[] args) throws PatternSyntaxException
   {
      var in = new Scanner(System.in);
      System.out.println("Wpisz wyrażenie regularne: ");
      String patternString = in.nextLine();

      Pattern pattern = Pattern.compile(patternString);

      while (true)
      {
         System.out.println("Wpisz łańcuch do dopasowania: ");
         String input = in.nextLine();
         if (input == null || input.equals(""))
            return;
         Matcher matcher = pattern.matcher(input);
         if (matcher.matches())
         {
            System.out.println("Dopasowanie!");
            int g = matcher.groupCount();
            if (g > 0)
            {
               for (int i = 0; i < input.length(); i++)
               {
                  // Wyświetlamy puste grupy
                  for (int j = 1; j <= g; j++)
                     if (i == matcher.start(j) && i == matcher.end(j))
                        System.out.print("()");
                  // Wyświetlamy ( dla niepustych grup - początek
                  for (int j = 1; j <= g; j++)
                     if (i == matcher.start(j) && i != matcher.end(j))
                        System.out.print("(");
                  System.out.print(input.charAt(i));
                  // Wyświetlamy ) dla niepustych grup - koniec
                  for (int j = 1; j <= g; j++)
                     if (i + 1 != matcher.start(j) && i + 1 == matcher.end(j))
                        System.out.print(")");
               }
               System.out.println();
            }
         } 
         else
            System.out.println("Brak dopasowania");
      }
   }
}
