package treeRender;

import java.awt.*;
import java.lang.reflect.*;
import javax.swing.*;
import javax.swing.tree.*;

/**
 * Klasa opisująca węzły drzewa czcionką zwykłą lub pochyloną (w przypadku 
 * klas abstrakcyjnych)
 */
public class ClassNameTreeCellRenderer extends DefaultTreeCellRenderer
{
   private Font plainFont = null;
   private Font italicFont = null;

   public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected,
         boolean expanded, boolean leaf, int row, boolean hasFocus)
   {
      super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, 
            row, hasFocus);
      // Pobiera obiekt użytkownika
      var node = (DefaultMutableTreeNode) value;
      Class<?> c = (Class<?>) node.getUserObject();

      // Przy pierwszym użyciu tworzy czcionkę pochyłą odpowiadającą danej czcionce prostej
      if (plainFont == null)
      {
         plainFont = getFont();
         // Obiekt rysujący komórkę drzewa wywoływany jest czasami
         // dla etykiety, która nie ma określonej czcionki (null)
         if (plainFont != null) italicFont = plainFont.deriveFont(Font.ITALIC);
      }

      // Wybiera czcionkę pochyłą, jeśli klasa jest abstrakcyjna
      if (Modifier.isAbstract(c.getModifiers())) setFont(italicFont);
      else setFont(plainFont);
      return this;
   }
}
