package ssl;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.concurrent.*;
import javax.net.*;
import javax.net.ssl.*;

/**
 * Program implementujący prosty serwer, który nasłuchuje na porcie 8189
 * lub porcie o numerze podanym w wierszu wywołania i odsyła przesłane teksty.
 * @version 1.0 2023-08-16
 * @author Cay Horstmann
 */
public class EchoServer
{
   public static void main(String[] args) throws IOException
   {
      int port = args.length >= 1 ? Integer.parseInt(args[0]) : 8189;
      // Nawiązanie połączenia serwerowego
      ServerSocketFactory factory = SSLServerSocketFactory.getDefault();
      try (ServerSocket s = factory.createServerSocket(port))
      {
         ExecutorService service = Executors.newVirtualThreadPerTaskExecutor();
         
         while (true)
         {
            // Oczekiwanie na połączenie od klienta
            Socket incoming = s.accept();
            service.submit(() -> serve(incoming));
         }
      }
   }
   
   public static void serve(Socket incoming)
   {
      try (var in = new Scanner(incoming.getInputStream());         
         var out = new PrintWriter(incoming.getOutputStream(),
            true /* autoFlush */))
      {
         out.println( "Cześć! Wpisz BYE, aby zakończyć." );
            
         // Zwrócenie tekstu przesłanego przez klienta
         boolean done = false;
         while (!done && in.hasNextLine())
         {  
            String line = in.nextLine();            
            out.println("Echo: " + line);            
            if (line.strip().equals("BYE"))
               done = true;
         }
      }
      catch (IOException e)
      {  
         e.printStackTrace();
      }
   }
}
