/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.serializer.AbstractContainerSerializer;
import org.eclipse.yasson.internal.serializer.ContainerModel;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class CollectionSerializer<T extends Collection>
extends AbstractContainerSerializer<T>
implements EmbeddedItem {
    private final JsonBindingModel containerModel;

    protected CollectionSerializer(SerializerBuilder builder) {
        super(builder);
        Type collectionValueType = this.getValueType();
        this.containerModel = new ContainerModel(collectionValueType, this.resolveContainerModelCustomization(collectionValueType, builder.getJsonbContext()));
    }

    private Type getValueType() {
        if (this.getRuntimeType() instanceof ParameterizedType) {
            Optional<Type> runtimeTypeOptional = ReflectionUtils.resolveOptionalType(this, ((ParameterizedType)this.getRuntimeType()).getActualTypeArguments()[0]);
            return (Type)((Object)runtimeTypeOptional.orElse((Type)((Object)Object.class)));
        }
        return Object.class;
    }

    @Override
    protected void serializeInternal(T collection, JsonGenerator generator, SerializationContext ctx) {
        for (Object item : collection) {
            this.serializeItem(item, generator, ctx, this.containerModel);
        }
    }

    @Override
    protected void writeStart(JsonGenerator generator) {
        generator.writeStartArray();
    }

    @Override
    protected void writeStart(String key, JsonGenerator generator) {
        generator.writeStartArray(key);
    }
}

