/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.JsonbRiParser;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.serializer.AbstractContainerDeserializer;
import org.eclipse.yasson.internal.serializer.ContainerModel;
import org.eclipse.yasson.internal.serializer.DeserializerBuilder;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;

class CollectionDeserializer<T extends Collection<?>>
extends AbstractContainerDeserializer<T>
implements EmbeddedItem {
    private final ContainerModel containerModel;
    private final Type collectionValueType = this.getRuntimeType() instanceof ParameterizedType ? ReflectionUtils.resolveType(this, ((ParameterizedType)this.getRuntimeType()).getActualTypeArguments()[0]) : Object.class;
    private T instance = this.createInstance();

    protected CollectionDeserializer(DeserializerBuilder builder) {
        super(builder);
        this.containerModel = new ContainerModel(this.collectionValueType, this.resolveContainerModelCustomization(this.collectionValueType, builder.getJsonbContext()));
    }

    @Override
    protected JsonBindingModel getModel() {
        return this.containerModel;
    }

    private T createInstance() {
        T x;
        Class<?> rawType = ReflectionUtils.getRawType(this.getRuntimeType());
        assert (Collection.class.isAssignableFrom(rawType));
        if (rawType.isInterface() && (x = this.createInterfaceInstance(rawType)) != null) {
            return x;
        }
        return (T)((Collection)ReflectionUtils.createNoArgConstructorInstance(rawType));
    }

    private T createInterfaceInstance(Class<?> ifcType) {
        if (List.class.isAssignableFrom(ifcType)) {
            if (LinkedList.class == ifcType) {
                return (T)new LinkedList();
            }
            return (T)new ArrayList();
        }
        if (Set.class.isAssignableFrom(ifcType)) {
            if (SortedSet.class.isAssignableFrom(ifcType)) {
                return (T)new TreeSet();
            }
            return (T)new HashSet();
        }
        if (Queue.class.isAssignableFrom(ifcType)) {
            return (T)new ArrayDeque();
        }
        if (Collection.class == ifcType) {
            return (T)new ArrayList();
        }
        return null;
    }

    @Override
    public T getInstance(Unmarshaller unmarshaller) {
        return this.instance;
    }

    @Override
    public void appendResult(Object result) {
        this.appendCaptor(this.convertNullToOptionalEmpty(this.getModel(), result));
    }

    private <T> void appendCaptor(T object) {
        this.instance.add(object);
    }

    @Override
    protected void deserializeNext(JsonParser parser, Unmarshaller context) {
        JsonbDeserializer<?> deserializer = this.newCollectionOrMapItem(this.collectionValueType, context.getJsonbContext());
        this.appendResult(deserializer.deserialize(parser, (DeserializationContext)context, this.collectionValueType));
    }

    @Override
    protected JsonbRiParser.LevelContext moveToFirst(JsonbParser parser) {
        parser.moveTo(JsonParser.Event.START_ARRAY);
        return parser.getCurrentLevel();
    }
}

