import java.io.*;
 
 public class AssertionError extends Error
 {
    private String method;
    private String sourceName;
    private int line = -1;
    
    public AssertionError (String message)
    {
       super (message);
 
       String s = stackEntry().trim();
       int space = s.indexOf (' ');
       int paren = s.indexOf ('(');
       int colon = s.indexOf (':');
 
       method = s.substring (space + 1, paren);
       sourceName = s.substring (paren + 1, colon);
       try
       {
          paren = s.indexOf (')');
          String ln = s.substring (colon+1, paren);
          line = Integer.parseInt (ln);
       }
       catch (NumberFormatException e)
       {
          System.out.println ("Bad format: " + s);
       }
    }
    
    public String getMethod()
    {
       return (method);
    }
 
    public String getSourceName()
    {
       return (sourceName);
    }
 
    public int getLineNumber()
    {
       return (line);
    }
 
    public String toString()
    {
       StringBuffer buf = new StringBuffer();
       buf.append ("Assert fail: " + getMessage());
       buf.append ("\n source: " + getSourceName());
       buf.append ("\n method: " + getMethod());
       buf.append ("\n line #: " + getLineNumber());
       return (buf.toString());
    }
    
    private String stackEntry()
    {
      String s = null;
      try
      {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter (sw);
        (new Exception()).printStackTrace (pw);
        String buf = sw.getBuffer().toString();
        StringReader sr = new StringReader (buf);
        BufferedReader br = new BufferedReader (sr);
  
        for (int i = 0; i < 4; i++) // opuszcza 4 wiersze
          br.readLine();   // po drodze do wywoujcej metody
        s = br.readLine();
      }
      catch (IOException e)
      {
        e.printStackTrace();
      }
      return (s);
    }
 }
