public final class Assert
 {
    /** Enable assertions using -DASSERT */
    private static final boolean ASSERT =
       System.getProperty ("ASSERT") != null;
    
    public static void assert (boolean assertion)
    {
       if (ASSERT && !assertion)
          throw new AssertionError (null);
    }
 
    public static void assert (boolean assertion,
                               String message)
    {
       if (ASSERT && !assertion)
          throw new AssertionError (message);
    }
    
    public static void main (String[] args) // test
    {
       try
       {
          Assert.assert (true, "never show this");
          Assert.assert (false, "show if -DASSERT");
       }
       catch (AssertionError e)
       {
          System.out.println (e);
       }
    }
 }
