 import javax.swing.*;
 import java.awt.event.*;
 import java.awt.*;
 import java.util.Properties;
 import java.io.FileInputStream;
 
 public class TestNotifyUser extends JFrame implements 
                                   ActionListener, NotifyCallback
 {
     JButton     btnAddNotify = new JButton("Add Notify");
     JButton     btnRemoveNotify = new JButton("Remove Notify");
     NotifyUser  notifyUser;
     String      iconFileName;
 
     public TestNotifyUser ()
     {
         super("Test Notify User");
         getContentPane().setLayout(new FlowLayout());
         getContentPane().add(btnAddNotify);
         getContentPane().add(btnRemoveNotify);
 
         btnAddNotify.addActionListener(this);
         btnRemoveNotify.addActionListener(this);
 
         try
         {
             FileInputStream fis =
                    new FileInputStream("TestNotifyUser.properties");
             Properties p = new Properties();
             p.load(fis);
             String className = p.getProperty("NotifyUserImpl");
             iconFileName = p.getProperty("IconFileName");
             fis.close();
 
             Class c = Class.forName(className);
             notifyUser = (NotifyUser) c.newInstance();
             notifyUser.installNotifyCallback(this);
         }
         catch (Exception e)
         {
             System.out.println("Error: " + e.getMessage());
             System.exit(1);
         }
 
         setSize(300,150);
         setVisible(true);
     }
 
     public void actionPerformed (ActionEvent evt)
     {
         if (evt.getSource() == btnAddNotify)
            notifyUser.addNotify(iconFileName, "You have new mail.");
         else if (evt.getSource() == btnRemoveNotify)
            notifyUser.removeNotify();
     }
 
     public void restoreApplication()
     {
         this.setState(Frame.NORMAL);
         notifyUser.removeNotify();
     }
 
     public static void main (String args[])
     {
         new TestNotifyUser();
     }
 }
