 public class MyPool extends ObjectPoolAdapter
 {
  static MyPool pool; // singleton
 
  private MyPool() { }
  
  public static MyPool getPool()
  { 
    if (pool == null)
     pool = new MyPool();
    return (pool);
  }
  
  public static MyObject getInstance()
    throws MyException
  {
   try
   {
    return((MyObject)MyPool.getPool().borrow());
   }    item 45
   catch (Exception e)
   {
    throw ((MyException) e);
   }
  }
  
  Object construct() throws Exception
  {
    return (new MyObject());
  }
  
  public static void main (String[] args)
  {
    // przykad uycia
    MyPool pool = MyPool.getPool();
    MyObject obj = null;
    try
    {
     obj = pool.getInstance();
     // uywa obiektu
    }
    catch (MyException e)
    {
     // zwyka obsuga wyjtku
    }
    finally
    {
     if (obj != null)
       pool.release (obj);
    }
  }
}
