 import java.awt.datatransfer.*;
 
 public class TransferableImage implements Transferable
 {
     public int     width;
     public int     height;
     public int     pixels[];
 
     DataFlavor flavor;
 
     public TransferableImage (int width, int height, int[] pixels)
                                                     throws Exception
     {
         flavor = new DataFlavor("image/raw");
 
         this.width = width;
         this.height = height;
         this.pixels = pixels;
     }
 
     public Object getTransferData(DataFlavor flavor)
                         throws UnsupportedFlavorException
     {
         if (flavor.equals(flavor))
             return (this);
         else
             throw new UnsupportedFlavorException(flavor);
     }
 
     public DataFlavor[] getTransferDataFlavors()
     {
         DataFlavor[] flavors = new DataFlavor[1];
         flavors[0] = flavor;
         return (flavors);
     }
 
     public boolean isDataFlavorSupported(DataFlavor flavor)
     {
         return (flavor.equals(flavor));
     }
 }
