 import java.awt.datatransfer.*;
 
 public class NativeRawImageAdaptor implements
                                 NativeClipboardAdaptor
 {
     static int  CF_DIB = 8;
     static int  BYTES_PER_INT = 4;
     byte[]      imageData;
     byte[]      bytesForInt;
     TransferableImage   outboundCopy;
     DataFlavor  flavor;
 
     public NativeRawImageAdaptor ()
     {
         try
         {
             flavor = new DataFlavor("image/raw");
         }
         catch (ClassNotFoundException cnfe) { }
     }
 
     public void setTransferable (Transferable t)
     {
         TransferableImage ti = (TransferableImage) t;
 
         // przekazywany format opisany jest przez width, height, pixels
         imageData =
             new byte[(ti.pixels.length + 2) * BYTES_PER_INT];
         insertIntIntoByteArray(imageData, ti.width, 0);
         insertIntIntoByteArray(
                     imageData, ti.height, 1 * BYTES_PER_INT);
 
         int offset = 2 * BYTES_PER_INT;
         for (int i = 0; i < ti.pixels.length; i++)
         {
             insertIntIntoByteArray2(imageData,
                                 ti.pixels[i], offset);
             offset += BYTES_PER_INT;
         }
     }
 
     public int getFormat ()
     {
         return (CF_DIB);
     }
 
     public byte[] getBytes()
     {
         return (imageData);
     }
 
     public void setBytes (byte[] b)
     {
         int width = getIntFromBytes(b, 0);
         int height = getIntFromBytes(b, 1 * BYTES_PER_INT);
 
         int[] pixels =
             new int[(b.length - 2 * BYTES_PER_INT) / BYTES_PER_INT];
         for (int i = 0; i < pixels.length; i++)
             pixels[i] = getIntFromBytes(
                     b, 2 * BYTES_PER_INT + (i * BYTES_PER_INT));
 
         outboundCopy = new TransferableImage(width, height, pixels);
     }
 
     public Object getClipboardData()
     {
         return (outboundCopy);
     }
 
     private int getIntFromBytes (byte[] b, int offset)
     {
 
         int i1 = (b[offset + 3] << 24) & 0xFF000000;
         int i2 = (b[offset + 2] << 16) & 0xFF0000;
         int i3 = (b[offset + 1] << 8) & 0xFF00;
         int i4 = b[offset + 0] & 0xFF;
 
         return (i1 | i2 | i3 | i4);
     }
 
     private void insertIntIntoByteArray(byte[] data,
                                         int i, int offset)
     {
         data[offset] = (byte) (i >> 0);
         data[offset + 1] = (byte) (i >> 8);
         data[offset + 2] = (byte) (i >> 16);
         data[offset + 3] = (byte) (i >> 24);
     }
 
     private void insertIntIntoByteArray2(byte[] data,
                                         int i, int offset)
     {
         data[offset] = (byte) (i >> 24);
         data[offset + 1] = (byte) (i >> 16);
         data[offset + 2] = (byte) (i >> 8);
         data[offset + 3] = (byte) (i >> 0);
     }
 }
