 import java.awt.datatransfer.*;
 import java.awt.Toolkit;
 import java.io.IOException;
 import java.util.*;
 
 public class NativeExtendedClipboard extends Clipboard
                                     implements Transferable
 {
     static
     {
         System.loadLibrary("NativeExtendedClipboard");
     }
 
     private Map          nativeFlavorMap;
     private Vector       nativeFlavors = new Vector();
 
     public NativeExtendedClipboard ()
     {
         super("NativeClipboard");
         createNativeFlavorMap();
     }
 
     private void createNativeFlavorMap ()
     {
         nativeFlavorMap = new HashMap();
         DataFlavor flavorImageRaw = null;
 
         try
         {
             flavorImageRaw = new DataFlavor("image/raw");
             nativeFlavors.add(flavorImageRaw);
 
             // tworzy map odwzorowania mimeType na obiekty adaptera
             nativeFlavorMap.put(flavorImageRaw.getMimeType(),
              Class.forName("NativeRawImageAdaptor").newInstance());
         }
         catch (Exception cnfe)
         {
             System.out.println("createNativeFlavorMap() error: " +
                                                 cnfe.getMessage());
         }
     }
 
     public Object getTransferData (DataFlavor flavor)
                              throws UnsupportedFlavorException
     {
         Iterator it = nativeFlavorMap.entrySet().iterator();
         while (it.hasNext())
         {
             //...znajduje odpowiedni NativeClipboardAdaptor (nca)...
             return (nca.getClipboardData());
         }
 
         throw new UnsupportedFlavorException (flavor);
     }
 
     public boolean isDataFlavorSupported (DataFlavor flavor)
     {
        // przeszukuje wektor dostepnych formatw macierzystego systemu operacyjnego,
        // zwraca warto true, gdy format jest dostpny, false w przeciwnym razie
     }
 
     public DataFlavor[] getTransferDataFlavors()
     {
         return ((DataFlavor[]) nativeFlavors.toArray());
     }
 
     public Transferable getContents (Object requestor)
     {
         int[] formats = getFormats();
 
         Iterator it = nativeFlavorMap.entrySet().iterator();
         while (it.hasNext())
         {
             Map.Entry entry = (Map.Entry) it.next();
             NativeClipboardAdaptor nca =
                   (NativeClipboardAdaptor) entry.getValue();
 
             for (int i = 0; i < formats.length; i++)
             {
                 if (nca.getFormat() == formats[i])
                 {
                     nca.setBytes(getBytes(formats[i]));
                     break;
                 }
             }
         }
 
         return (this);
     }
 
     public void setContents (Transferable contents,
                                         ClipboardOwner owner)
     {
         setNativeTransferable(contents);
     }
 
     private void setNativeTransferable (Transferable contents)
     {
         DataFlavor[] flavors = contents.getTransferDataFlavors();
         String       className = "";
         boolean      foundIt = false;
 
         Iterator it = nativeFlavorMap.entrySet().iterator();
         while (it.hasNext())
         {
             Map.Entry entry = (Map.Entry) it.next();
             String key = (String) entry.getKey();
 
             // uywa pierwszego, ktry pasuje
             for (int i = 0; i < flavors.length; i++)
             {
                 if (flavors[i].getMimeType().equals(key))
                 {
                     NativeClipboardAdaptor nca =
                         (NativeClipboardAdaptor) entry.getValue();
                     nca.setTransferable(contents);
                     setNativeClipboardData(
                                 nca.getFormat(), nca.getBytes());
                     foundIt = true;
                     break;
                 }
             }
 
             if (foundIt)
                 break;
         }
     }
 
     private native int[] getFormats ();
     private native byte[] getBytes (int format);
     private native void setNativeClipboardData (
                             int format, byte[] bytes);
 }
