public class NumericValidator
    extends ValidationAdapter
 {
   double min = Double.MIN_VALUE;
   double max = Double.MAX_VALUE;
   
   public void setRange (double min, double max)
   {
     this.min = min;
     this.max = max;
   }
 
   public boolean isValid (Object value)
   {
     boolean valid = false;
 
     if (value != null)
     {
       try
       {
         double d =
           Double.parseDouble (value.toString());
         valid = ((d >= min) && (d <= max));
       }
       catch (NumberFormatException e) { }
     }
     
     return (valid);
   }
 
   public static boolean accepts (Object value)
   {
     return
       (new NumericValidator().isValid (value));
   }
 }
