 import java.awt.*;
 import java.awt.event.*;
 
 public abstract class FilterAdapter
 implements KeyListener
 {
    static Toolkit tk = Toolkit.getDefaultToolkit();
    boolean audio = true;
    
    public FilterAdapter (Component comp)
    {
       comp.addKeyListener (this);
    }
    
    public void enableAudio (boolean status)
    {
       this.audio = status; // sygna dwikowy
    }
 
    public abstract boolean isKeyValid (KeyEvent e);
 
    // implementuje KeyListener
    public void keyTyped (KeyEvent e)
    {
       if (e.isActionKey()) // ignoruje klawisze akcji
          return;
        if (isKeyValid (e))
          return;
 
        e.consume(); // filtruje nacinicie klawisza
        if (audio)
          tk.beep();
    }
    public void keyPressed  (KeyEvent e) { }
    public void keyReleased (KeyEvent e) { }
 }
