 import java.awt.*;
 import java.awt.event.*;
 import javax.swing.*;
 
 public class BarChartLayered
 extends JLayeredPane implements ActionListener
 {
    static int barHeight = 40;
    int barCount;
    
    public BarChartLayered()
    {
       super();
       setPreferredSize (new Dimension (200, 200));
       setLayout (null);
 
       addBackground(); // kolejno nie ma teraz znaczenia
       addBar ("March", 100, Color.red);
       addBar ("April", 120, Color.yellow);
       addBar ("May",   160, Color.green);
       addBar ("June",  130, Color.white);
    }
    
    private void addBackground()
    {
       JButton background = new JButton();
       background.setActionCommand ("background");
       background.setBounds (0, 0, 200, 200);
       background.setOpaque (false);
       background.addActionListener (this);
        int layer =
           JLayeredPane.DEFAULT_LAYER.intValue() - 1;
        add (background, new Integer (layer));
    }
    
    private void addBar (String lbl, int w, Color c)
    {
       JButton bar = new JButton (lbl);
       int y = barCount * (barHeight + 10);
       bar.setBounds (10, y, w, barHeight);
       bar.setBackground (c);
       bar.addActionListener (this);
        add (bar, JLayeredPane.DEFAULT_LAYER);
       barCount++;
    }
 
    public void actionPerformed (ActionEvent e)
    {
       System.out.println
          ("Button = " + e.getActionCommand());
    }
          
    public static void main (String[] args)
    {
       BarChartLayered panel =
          new BarChartLayered();
       JFrame frame =
          new JFrame ("BarChart Layered");
       frame.getContentPane().setLayout
          (new BorderLayout());
       frame.getContentPane().add
          (panel, BorderLayout.CENTER);
       frame.pack();
       frame.show();
    }
 }

