 import java.awt.*;
 import java.awt.event.*;
 import java.util.Vector;
 
 public class TextFieldList extends Frame implements ActionListener
 {
     int     dockPosition = 0;
     int     textFieldTotal = 0;
     Button  dockButton = new Button("Dock >");
     Button  addTextFieldButton = new Button("Add Text Field");
     Button  removeTextFieldButton = new Button ("Remove Text Field");
     Panel   pButtons = new Panel();
     Panel   pCenter = new Panel();
     Vector  v = new Vector();
 
     public TextFieldList (String title)
     {
         super(title);
 
         setLayout(new BorderLayout());
         pButtons.setLayout(new FlowLayout());
         pCenter.setLayout(new FlowLayout());
 
         pButtons.add(dockButton);
         pButtons.add(addTextFieldButton);
         pButtons.add(removeTextFieldButton);
 
         dockButton.addActionListener(this);
         addTextFieldButton.addActionListener(this);
         removeTextFieldButton.addActionListener(this);
 
         addTextField(pCenter);
         addTextField(pCenter);
         add("North", pButtons);
         add("Center", pCenter);
 
         setSize(600,400);
         setVisible(true);
     }
 
     private void addTextField (Panel p)
     {
         TextField tf = new TextField("Text: " + textFieldTotal, 30);
         v.addElement(tf);
         p.add(tf);
         textFieldTotal++;
     }
 
     private void removeTextField (Panel p)
     {
         if (textFieldTotal > 0)
         {
             textFieldTotal--;
             p.remove((Component)v.elementAt(textFieldTotal));
             v.removeElementAt(textFieldTotal);
         }
     }
 
     public void actionPerformed (ActionEvent evt)
     {
         Object source = evt.getSource();
 
         if (source == addTextFieldButton)
         {
             addTextField(pCenter);
              pCenter.repaint();
         }
         else if (source == removeTextFieldButton)
         {
             removeTextField(pCenter);
              pCenter.repaint();
         }
         else if (source == dockButton)
         {
             remove(pButtons);
             switch (dockPosition)
             {
                 case 0:
                     add("West", pButtons);
                     break;
                 case 1:
                     add("South", pButtons);
                     break;
                 case 2:
                     add("East", pButtons);
                     break;
                 case 3:
                     add("North", pButtons);
                     break;
             }
             if (dockPosition == 3)
                 dockPosition = 0;
             else
                 dockPosition++;
 
              repaint();
         }
     }
 
     public static void main (String args[])
     {
         new TextFieldList("TextFieldList");
     }
 }
