 import java.awt.*;
 import java.awt.event.*;
 import javax.swing.*;

 public class Monitor implements ActionListener
 {
    private Measurable task;
    private ProgressMonitor pm;
    private Timer timer;

    public Monitor (Measurable task)
    {
       this.task = task;
    }

    public void spawn (final Component component)
    {
       Runnable worker = new Runnable() {
          public void run() {
             startMonitor (component);
          }
       };

       Thread thread = new Thread (worker);
       thread.start();
    }

    public void startMonitor (Component c)
    {
       pm = new ProgressMonitor (c,null,"",0,100);
       pm.setProgress (1); // wymusza pojawienie si monitora
       pm.setMillisToDecideToPopup (0);
       timer = new Timer (1000, this); // 1 sekunda
       timer.start();
    }

    // wywoywana przez licznik czasu
    public void actionPerformed (ActionEvent event)
    {
       int progress = task.getProgress();
       if ((progress >= 100) || pm.isCanceled())
       {
          pm.close();
          timer.stop();
          if (progress < 100)
             task.stopTask(); // przerywa operacj
       }
       else
       {
          pm.setNote (task.getActivity());
          pm.setProgress (progress);
       }
    }

    public static void main (String[] args) 
    {
       JFrame frame = new JFrame ("Monitor Demo");
       frame.setVisible (true);

       Measurable task = new Measurable() {
          private int p;
          public int getProgress()    item 29
          {
             return (p += (int)(Math.random()*20));
          }
          public String getActivity()
          {
             return (p + "% complete");
          }
          public void stopTask() { System.exit(0); }
       };

       Monitor monitor = new Monitor (task);
       monitor.spawn (frame);
       frame.setTitle ("Back in main thread");
    }
 }
