/* ObjectSender1.java */
 import java.io.*;
 import java.net.*;
 
 public class ObjectSender1
 {
     Socket s;
     ObjectInputStream ois;
     ObjectOutputStream oos;
     
     public ObjectSender1(String host, int port) throws IOException
     {
         s = new Socket(host, port);    
         ois = new ObjectInputStream(s.getInputStream());
         oos = new ObjectOutputStream(s.getOutputStream());
     }
     
     public void sendObject(Object o) throws IOException
     {
         oos.writeObject(o);    
     }
     
     public static void main(String args[])
     {
         if (args.length < 2)
         {
           System.out.println("USAGE: java ObjectSender1 host port");
           System.exit(1);
         }
                 
         try
         {
             ObjectSender1 os1 = new ObjectSender1(args[0], 
                                  Integer.parseInt(args[1]));    
             os1.sendObject(new Integer(3000));
             Thread.sleep(2000); // zawiesza wykonanie na 2 sekundy
         } catch (Exception e)
           {
             e.printStackTrace();  
           }
     }
 }
