/* ObjectReceiver1.java */
 import java.io.*;
 import java.net.*;
 
 public class ObjectReceiver1
 {
     ServerSocket ss;
     
     public ObjectReceiver1(int port) throws IOException
     {
         ss = new ServerSocket(port);    
     }
     
     public void listen() throws IOException, ClassNotFoundException
     {
         Socket s = ss.accept();
         ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
         ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
         Object o = ois.readObject();    
         System.out.println("Object: " + o);
     }
     
     public static void main(String args[])
     {
         if (args.length < 1)
         {
             System.out.println("USAGE: java ObjectReceiver1 port");
             System.exit(1);
         }
                 
         try
         {
             ObjectReceiver1 or1 = 
                   new ObjectReceiver1(Integer.parseInt(args[0]));    
             or1.listen();
         } catch (Exception e)
           {
             e.printStackTrace();  
           }
     }
 }
