/* CommandPattern3.java */
 
 import java.lang.reflect.*;
 import java.awt.*;
 import java.awt.event.*;
 import javax.swing.*;
 
 class App
 {
     public void binarySearch()
     { System.out.println("App1.binarySearch()"); }
     
     public void mergeSort()
     { System.out.println("App1.mergeSort()"); }
 }
 
 class Command implements ActionListener
 {
     Object o;
     Method m;
     Object [] args;
     
     public Command(Object o, Method m, Object [] args)
     { this.o = o; this.m = m; this.args = args; }
     
     public void actionPerformed(ActionEvent evt)
     {
         try
         {
             m.invoke(o, args);
         } catch (Exception e)
           { e.printStackTrace(); }
     }
 }
 
 class AppGui extends JFrame
 {
     public AppGui(App app1) throws NoSuchMethodException
     {
         super("Command Pattern 1");
         getContentPane().setLayout(new FlowLayout());
         JButton searchButton = new JButton("Search");
         Method m = app1.getClass().getMethod("binarySearch", null);
         Command searchCommand = new Command(app1, m, null);
         searchButton.addActionListener(searchCommand);
         JButton sortButton = new JButton("Sort");
         Method m2 = app1.getClass().getMethod("mergeSort", null);
         Command sortCommand = new Command(app1, m2, null);
         sortButton.addActionListener(sortCommand);
         getContentPane().add(searchButton);
         getContentPane().add(sortButton);
         addWindowListener(new WindowAdapter()
              { public void windowClosing(WindowEvent we)
                { System.exit(0); } } );
         pack();
         setLocation(100,100);
         setVisible(true);
     }
 }
 
 public class CommandPattern3
 {
     public static void main(String args[]) 
                        throws NoSuchMethodException
     {
         App app = new App();
         AppGui gui = new AppGui(app);
     }
 }
