/* CommandPattern2.java */
 
 import java.lang.reflect.*;
 import java.awt.*;
 import java.awt.event.*;
 import javax.swing.*;
 
 class App
 {
     public void binarySearch()
     { System.out.println("App1.binarySearch()"); }
     
     public void mergeSort()
     { System.out.println("App1.mergeSort()"); }
 }
 
 abstract class Command implements ActionListener
 {
     App app;
     
     public Command(App app)
     { this.app = app; }
     
     public abstract void actionPerformed(ActionEvent evt);
 }
 
 class AppGui extends JFrame
 {
     public AppGui(App app1)  
     {
         super("Command Pattern 1");
         getContentPane().setLayout(new FlowLayout());
         JButton searchButton = new JButton("Search");
         searchButton.addActionListener(new Command(app1)
                 {
                     public void actionPerformed(ActionEvent evt)
                     { app.binarySearch(); }
                 });
         JButton sortButton = new JButton("Sort");
         sortButton.addActionListener(new Command(app1)
                 {
                     public void actionPerformed(ActionEvent evt)
                     { app.mergeSort(); }
                 });                
         getContentPane().add(searchButton);
         getContentPane().add(sortButton);
         addWindowListener(new WindowAdapter()
                           { public void windowClosing(WindowEvent we)
                             { System.exit(0); } } );
         pack();
         setLocation(100,100);
         setVisible(true);
     }
 }
 
 public class CommandPattern2
 {
     public static void main(String args[])
     {
         App app = new App();
         AppGui gui = new AppGui(app);
     }
 }
