/* CommandPattern1.java */
 
 import java.lang.reflect.*;
 import java.awt.*;
 import java.awt.event.*;
 import javax.swing.*;
 
 class App
 {
     public void binarySearch()
     { System.out.println("App1.binarySearch()"); }
     
     public void mergeSort()
     { System.out.println("App1.mergeSort()"); }
 }
 
 class Command implements ActionListener
 {
     static final int SEARCH = 0;
     static final int SORT = 1;
     
     App app;
     int cmdIndex;
     
     public Command(App app, int cmdIndex)
     { this.app = app; this.cmdIndex = cmdIndex; }
     
     public void actionPerformed(ActionEvent evt)
     {
         switch (cmdIndex)
         {
             case SEARCH:
                 app.binarySearch();
                 break;
             case SORT:
                 app.mergeSort();
                 break;
         }
     }
 }
 
 class AppGui extends JFrame
 {
     public AppGui(App app)  
     {
         super("Command Pattern 1");
         getContentPane().setLayout(new FlowLayout());
         JButton searchButton = new JButton("Search");
         Command searchCommand = new Command(app,Command.SEARCH);
         searchButton.addActionListener(searchCommand);
         JButton sortButton = new JButton("Sort");
         Command sortCommand = new Command(app,Command.SORT);
         sortButton.addActionListener(sortCommand);
         getContentPane().add(searchButton);
         getContentPane().add(sortButton);
         addWindowListener(new WindowAdapter()
                     { public void windowClosing(WindowEvent we)
                             { System.exit(0); } } );
         pack();
         setLocation(100,100);
         setVisible(true);
     }
 }
 
 public class CommandPattern1
 {
     public static void main(String args[])
     {
         App app = new App();
         AppGui gui = new AppGui(app);
     }
 }
