import java.util.Hashtable;
 
 public class Clone1
 {
     public static void main (String args[])
     {
         // owca doskonaa wyhodowana przez Boba
         Sheep sheep1 = new Sheep("Wooly", "Farmer Bob",
                             "White w/Black Patches", 123.7f);
 
         // klon owcy sprzedawany Rickowi
         Sheep sheep2 = (Sheep) sheep1.clone();
         sheep2.setOwnerName("Farmer Rick");
 
         sheep2.name = "Patch";    // Rick zmienia nazw owcy
         sheep2.setWeight(149.2f);   // karmi j dzie i noc
         sheep2.setColor("Purple");  // i barwi jej wen
 
         // wynik
         System.out.println("Sheep1:\n" + sheep1.toString());
         System.out.println("\nSheep2:\n" + sheep2.toString());
     }
 }
 
 class Sheep implements Cloneable
 {
     public  String      name;
     private Person      owner = new Person();
     private Hashtable   attributes = new Hashtable();
 
     public Sheep (String name, String ownerName,
                     String color, float weight)
     {
         this.name = name;
         this.setOwnerName(ownerName);
         this.setColor(color);
         this.setWeight(weight);
     }
 
     public String getOwnerName ()
     {   return (owner.name); }
 
     public void setOwnerName (String ownerName)
     {   owner.name = ownerName;  }
 
     public String getColor ()
     {   return ((String)attributes.get("Color"));   }
 
     public void setColor (String color)
     {   attributes.put("Color", color);    }
 
     public float getWeight ()
     {
         return (((Float) attributes.get("Weight")).floatValue());
     }
 
     public void setWeight (float weight)
     {   attributes.put("Weight", new Float(weight));   }
 
     public Object clone ()
     {
         try
         {
             return (super.clone());
         }
         catch (CloneNotSupportedException e)
         {
             throw new InternalError();
         }
     }
 
     public String toString ()
     {
         return ("Name: " + this.name +
                 "\nOwner: " + this.getOwnerName() +
                 "\nColor: " + this.getColor() +
                 "\nWeight: " + this.getWeight());
     }
 }
 
 class Person
 {
     public String name;
 }
