import java.util.Date;
 
 class PunchTimeCard
 {
     Date dt = new Date();
     public synchronized void punch (String name)
     {
         System.out.println(name + " punched in at: \t" +
          ((int)(System.currentTimeMillis() - dt.getTime()) / 1000));
 
         try { Thread.currentThread().sleep (1000); }
         catch (InterruptedException ie) { }
     }
 }
 
 class Employee extends Thread
 {
     String          name;
     PunchTimeCard   ptc;
 
     public Employee (String name, PunchTimeCard ptc)
     {
         this.name = name;
         this.ptc = ptc;
     }
 
     public void run ()
     {
         while (true)
         {
             ptc.punch(name);
         }
     }
 }
 
 public class Work
 {
     public static void main (String args[])
     {
         PunchTimeCard ptc = new PunchTimeCard();
         Employee jerry = new Employee("Jerry", ptc);
         Employee sherrie = new Employee("Sherrie", ptc);
         jerry.start();
         sherrie.start();
     }
 }
