import java.util.*;
 
 class WiseMan
 {
     String name;
     String questionType;
     Hashtable otherWiseMen = new Hashtable();
 
     public WiseMan (String name, String questionType)
     {
         this.name = name;
         this.questionType = questionType;
     }
 
     public synchronized String askQuestion(String s, String asker)
     {
         System.out.println("WiseMan " + name +
                         " takes question from " + asker);
         StringTokenizer st = new StringTokenizer(s);
         if (st.hasMoreTokens())
         {
             String thisQuestionType = st.nextToken();
             if (thisQuestionType.equalsIgnoreCase(questionType))
             {
                 return ("WiseMan " + name + " sayeth: " +
                 "The answer you are seeking lies within yourself.");
             }
             else
             {
                 WiseMan otherWiseMan =
                     (WiseMan) otherWiseMen.get(thisQuestionType);
                 if (otherWiseMan == null)
                     return ("Please come back another day");
                 else
                 {
                     System.out.println("WiseMan " + name +
                     " conferring with WiseMan " + otherWiseMan.name);
                     return ("WiseMan " + name + " sayeth: " +
                      otherWiseMan.askQuestion(s, "WiseMan " + name));
                 }
             }
         }
         else
             return ("Please repeat your question");
     }
 
     public synchronized void addWiseMan (WiseMan wiseMan)
     {
         otherWiseMen.put(wiseMan.questionType, wiseMan);
     }
 }
 
 class KnowledgeSeeker extends Thread
 {
     String  name;
     WiseMan wiseMan;
     String  question;
 
     public KnowledgeSeeker (String name, WiseMan wiseMan,
                                             String question)
     {
         this.name = name;
         this.wiseMan = wiseMan;
         this.question = question;
     }
 
     public void run ()
     {
         while (true)
         {
             System.out.println("Knowledge Seeker " + name +
                                         " asks: " + question);
             String answer = wiseMan.askQuestion(question, name);
             System.out.println("Knowledge Seeker " + name +
                                         " answer: " + answer);
         }
     }
 }
 
 public class Sanctuary
 {
     public static void main (String args[])
     {
         WiseMan wiseManA = new WiseMan("A", "What");
         WiseMan wiseManB = new WiseMan("B", "Where");
 
         wiseManA.addWiseMan(wiseManB);
         wiseManB.addWiseMan(wiseManA);
 
         KnowledgeSeeker ks1 = new KnowledgeSeeker("pupil 1",
                     wiseManA, "What is the meaning of life?");
 
         KnowledgeSeeker ks2 = new KnowledgeSeeker("pupil 2",
             wiseManB, "Where are the seven wonders of the world?");
 
         KnowledgeSeeker ks3 = new KnowledgeSeeker("pupil 3",
                     wiseManA, "Where is the restroom?");
 
         KnowledgeSeeker ks4 = new KnowledgeSeeker("pupil 4",
                     wiseManB, "What is the square root of pi?");
 
         ks1.start();
         ks2.start();
         ks3.start();
         ks4.start();
     }
 }
