 import javax.swing.*;
 import java.awt.*;
 import java.awt.event.*;
 
 public class SwingNotifyUser implements NotifyUser
 {
     SwingNotifyFrame f;
     NotifyCallback   callback;
 
     public void addNotify (String iconFileName, String message)
     {
         f = new SwingNotifyFrame("Notify", message, iconFileName);
         f.installNotifyCallback(callback);
     }
 
     public void removeNotify ()
     {
         if (f != null)
             f.dispose();
     }
 
     public void installNotifyCallback (NotifyCallback callback)
     {
         this.callback = callback;
         if (f != null)
             f.installNotifyCallback(callback);
     }
 }
 
 class SwingNotifyFrame extends JFrame implements ActionListener
 {
     JButton viewMailButton = new JButton("View Mail");
     JButton cancelButton = new JButton("Cancel");
     NotifyCallback  callback;
 
     SwingNotifyFrame (String frameTitle, String message,
                                            String iconFileName)
     {
         super(frameTitle);
 
         //...kod zwizany z ukadem komponentw...
 
         pCenter.add(new JLabel(new ImageIcon(iconFileName)));
         pCenter.add(new JLabel(message));
 
         pButtons.add(viewMailButton);
         pButtons.add(cancelButton);
 
         viewMailButton.addActionListener(this);
         cancelButton.addActionListener(this);
 
         //... kod zwizany z ukadem komponentw...
 
         setVisible(true);
     }
 
     public void actionPerformed (ActionEvent evt)
     {
         if (evt.getSource() == viewMailButton)
         {
             if (callback != null)
                 callback.restoreApplication();
         }
         else
             this.dispose();
     }
 
     void installNotifyCallback (NotifyCallback callback)
     {
         this.callback = callback;
     }
 }
