 #include <windows.h>
 #include <string.h>
 #include "NativeNotifyUser.h"
 
 void replaceChar (char *, int, int);
 LRESULT CALLBACK CallWndProc(int, WPARAM, LPARAM);
 HWND GetTopLevelWindowHandle ();
 BOOL CALLBACK EnumWindowsProc (HWND, LPARAM);
 
 HHOOK      m_hookId;
 HWND      m_hWnd;
 UINT      m_callbackMessage = 101;
 HWND      m_hwndTopLevelWindow;
 DWORD      m_dwProcessId;
 
 JavaVM   *m_vm;
 jobject   m_pNotifyCallbackObject;
 jmethodID   m_method_id;
 
 BOOL APIENTRY DllMain( HANDLE hModule,
                        DWORD  ul_reason_for_call,
                        LPVOID lpReserved
                 )
 {
     return TRUE;
 }
 
 JNIEXPORT void JNICALL Java_NativeNotifyUser_addNotify
   (JNIEnv *pEnv, jobject pObject,
    jstring iconFileName, jstring message)
 {
     const char  *cc_iconFileName;
     const char  *cc_message;
     char        caBuffer[256];
     NOTIFYICONDATA tnid;
 
     cc_iconFileName =
             (*pEnv)->GetStringUTFChars(pEnv, iconFileName, 0);
     cc_message = (*pEnv)->GetStringUTFChars(pEnv, message, 0);
 
     tnid.cbSize = sizeof(NOTIFYICONDATA);
     m_hWnd = GetTopLevelWindowHandle();
     tnid.hWnd = m_hWnd;
     tnid.uID = 1;
     tnid.uCallbackMessage = m_callbackMessage;
     tnid.uFlags = NIF_ICON | NIF_TIP | NIF_MESSAGE;
     strcpy(caBuffer, cc_iconFileName);
     replaceChar(caBuffer, '/', '\\');
     tnid.hIcon =
       LoadImage(NULL, caBuffer, IMAGE_ICON, 0, 0, LR_LOADFROMFILE);
     lstrcpyn(tnid.szTip, cc_message, sizeof(tnid.szTip));
 
     Shell_NotifyIcon(NIM_ADD, &tnid);
     m_hookId = SetWindowsHookEx(WH_CALLWNDPROC, &CallWndProc, NULL,
                       GetWindowThreadProcessId(m_hWnd, NULL));
     DestroyIcon(tnid.hIcon);
     (*pEnv)->ReleaseStringUTFChars(pEnv, iconFileName,
                                              cc_iconFileName);
     (*pEnv)->ReleaseStringUTFChars(pEnv, message, cc_message);
 }
 
 JNIEXPORT void JNICALL Java_NativeNotifyUser_removeNotify
   (JNIEnv *pEnv, jobject pObject)
 {
     NOTIFYICONDATA tnid;
 
     tnid.cbSize = sizeof(NOTIFYICONDATA);
     tnid.hWnd = m_hWnd;
     tnid.uID = 1;
     UnhookWindowsHookEx(m_hookId);
     Shell_NotifyIcon(NIM_DELETE, &tnid);
 }
 
 JNIEXPORT void JNICALL Java_NativeNotifyUser_installNotifyCallback
   (JNIEnv *pEnv, jobject pObject, jobject pNotifyCallbackObject)
 {
     jclass pNotifyCallbackClass;
 
     (*pEnv)->GetJavaVM(pEnv, &m_vm);
     m_pNotifyCallbackObject =
        (*pEnv)->NewGlobalRef(pEnv, pNotifyCallbackObject);
     pNotifyCallbackClass =
        (*pEnv)->GetObjectClass(pEnv, pNotifyCallbackObject);
     m_method_id =
        (*pEnv)->GetMethodID(pEnv, pNotifyCallbackClass,
                        "restoreApplication", "()V");
 }
 
 void replaceChar (char *cpString, int charToReplace, 
                           int replaceChar)
 {
     char   *cpPosition;
 
     while ((cpPosition = strchr(cpString, charToReplace)) != NULL)
        cpPosition[0] = replaceChar;
 }
 
 LRESULT CALLBACK CallWndProc(int nCode, WPARAM wParam, 
                              LPARAM lParam)
 {
     CWPSTRUCT   *cwp;
     jint      returnCode;
     JNIEnv      *pEnv;
 
     if (nCode < 0)
        return (CallNextHookEx(m_hookId, nCode, wParam, lParam));
     else
     {
        cwp = (CWPSTRUCT*) lParam;
        if (cwp->message == m_callbackMessage)
        {
           if (cwp->lParam == WM_LBUTTONDBLCLK)
           {
              if (m_pNotifyCallbackObject != NULL)
              {
                 returnCode =
                    (*m_vm)->GetEnv(m_vm, (void**) &pEnv,
                               JNI_VERSION_1_2);
                 (*pEnv)->CallVoidMethod(pEnv,
                    m_pNotifyCallbackObject, m_method_id);
              }
           }
        }
     }
 
     return (CallNextHookEx(m_hookId, nCode, wParam, lParam));
 }
 
 HWND GetTopLevelWindowHandle ()
 {
     m_dwProcessId = GetCurrentProcessId();
     EnumWindows (&EnumWindowsProc, 0);
 
     return (m_hwndTopLevelWindow);
 }
 
 BOOL CALLBACK EnumWindowsProc (HWND hwnd, LPARAM pProcessId)
 {
     DWORD   dwProcessId;
 
     GetWindowThreadProcessId (hwnd, &dwProcessId);
     if (m_dwProcessId == dwProcessId)
     {
        m_hwndTopLevelWindow = hwnd;
        return (FALSE);
     }
     return (TRUE);
 }
