public class DebugManager
  {
    public static final String SYSTEM_DEBUG_KEY = "system.Debug";
    public static final boolean debug;
    static
    {
      debug = toBoolean(SYSTEM_DEBUG_KEY);
    }
    private static boolean toBoolean(String key)
    {
      String sDebug = System.getProperty(key);
      if (sDebug != null && sDebug.equalsIgnoreCase("true"))
        debug = true;
      else
        debug = false;
    }
    public static boolean getSystemDebug()
    {
      return debug;
    }
    public static boolean getSystemDebug(String applicationKey)
    {
      if (debug || debugToBoolean(applicationKey))
        return true;
      else
        return false;
    }
  }
