import java.util.*;
 
 public abstract class ObjectPoolAdapter
 {
  private Stack pool;
  
  ObjectPoolAdapter()
  {
    pool = new Stack();
  }
   
  synchronized Object borrow() throws Exception
  {
    Object obj;       
    if (pool.size() > 0)
     obj = pool.pop(); // odzysk
    else
     obj = construct();
    return (obj);
  }
   
  synchronized void release (Object obj)
  {
    pool.push (obj);
  }
 
  abstract Object construct() throws Exception;
 }
