 import javax.swing.*;
 import java.net.*;
 import java.awt.event.*;
 import java.awt.print.*;
 import java.awt.*;
 import java.io.*;
 
 public class JEditorPaneFrame extends JFrame
                             implements ActionListener
 {
     JMenuItem print = new JMenuItem("Print");
     JMenuItem exit = new JMenuItem("Exit");
     MyEditor editor;
 
     public JEditorPaneFrame (String title)
     {
         super(title);
 
         try
         {
             print.addActionListener(this);
             exit.addActionListener(this);
             JMenu file = new JMenu("File");
             file.add(print);
             file.add(exit);
             JMenuBar menuBar = new JMenuBar();
             menuBar.add(file);
             setJMenuBar(menuBar);
 
             URL url =
                 new URL("file:/d:/jdk1.3/docs/guide/2d/index.html");
             editor = new MyEditor(url);
 
             JScrollPane sp = new JScrollPane(editor);
 
             editor.setEditable(false);
             getContentPane().add("Center", sp);
         }
         catch (Exception e)
         {
             System.out.println("Error: " + e.getMessage());
             System.exit(1);
         }
 
         setSize(400,400);
         setVisible(true);
     }
 
     public void actionPerformed(ActionEvent evt)
     {
         if (evt.getSource() == print)
         {
             PrinterJob job = PrinterJob.getPrinterJob();
             job.setPrintable(editor);
             try
             {
                 job.print();
             }
             catch (PrinterException pe)
             {
                 System.out.println("Printer Error: " +
                                             pe.getMessage());
             }
         }
         else if (evt.getSource() == exit)
         {
             this.dispose();
             System.exit(1);
         }
     }
 
     public static void main (String args[])
     {
         new JEditorPaneFrame("Test JEditor Pane Print");
     }
 }
 
 class MyEditor extends JEditorPane implements Printable
 {
     public MyEditor (URL url) throws IOException
     {
         super (url);
     }
 
     public int print (Graphics graphics, PageFormat pageFormat,
                                                    int pageIndex)
     {
         if (pageIndex == 0)
         {
             printAll(graphics);
             return (Printable.PAGE_EXISTS);
         }
         else
             return (Printable.NO_SUCH_PAGE);
     }
 }
