#include <windows.h>
 #include "NativeExtendedClipboard.h"
 #include "NativeExtendedTransferable.h"
 
 #define PALETTE_SIZE   256
 
 typedef struct _JavaBitmapData
 {
   int       width;
   int       height;
   int       pixels[1];
 } JavaBitmapData;
 
 UINT    newRegisteredFormat = 0;
 
 BOOL APIENTRY DllMain( HANDLE hModule,
                        DWORD  ul_reason_for_call,
                        LPVOID lpReserved
                 )
 {
   return TRUE;
 }
 
 JNIEXPORT void JNICALL
    Java_NativeExtendedClipboard_setNativeClipboardData
     (JNIEnv *pEnv, jobject pObject, jint format, jbyteArray data)
 {
   HGLOBAL   handle;
   char      *javaData;
   jboolean  isCopy = FALSE;
 
   JavaBitmapData    *javaBitmapData;
   BITMAPINFOHEADER  *bitmapHeader;
   RGBQUAD           *colorTable;
   char              *bitmapData;
 
   unsigned char     red, blue, green, alpha;
   int               width, height, xwidth;
   int               pixelIndex, alignedBitmapIndex, bitmapIndex;
   int               numColors = 0;
   BOOL              colorMatch = FALSE;
   int               i, j, k;
 
   if (OpenClipboard(NULL))
   {
     if (format == CF_DIB)
     {
       javaData =
         (*pEnv)->GetByteArrayElements(pEnv, data, &isCopy);
       javaBitmapData = (JavaBitmapData *) javaData;
 
       width = javaBitmapData->width;
       height = javaBitmapData->height;
       if (width % sizeof(DWORD) == 0)
         xwidth = width;
       else
         xwidth = width + (sizeof(DWORD) -
                         (width % sizeof(DWORD)));
 
       handle = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE,
         (xwidth * height) + sizeof(BITMAPINFOHEADER) +
         (PALETTE_SIZE * sizeof(RGBQUAD)));
       bitmapHeader = (BITMAPINFOHEADER*) GlobalLock(handle);
       bitmapHeader->biSize = sizeof(BITMAPINFOHEADER);
       bitmapHeader->biWidth = javaBitmapData->width;
       bitmapHeader->biHeight = javaBitmapData->height;
       bitmapHeader->biPlanes = 1;
       bitmapHeader->biBitCount = 8;
       bitmapHeader->biCompression = BI_RGB;
       bitmapHeader->biSizeImage = 0;
       bitmapHeader->biXPelsPerMeter = 0;
       bitmapHeader->biYPelsPerMeter = 0;
       bitmapHeader->biClrUsed = 0;
       bitmapHeader->biClrImportant = 0;
 
       // wskanik utworzonego bufora
       colorTable = (RGBQUAD*) (((char*)bitmapHeader) +
                                sizeof(BITMAPINFOHEADER));
       bitmapData = (char*) (colorTable + PALETTE_SIZE);
 
       // tworzy tablic kolorw
       // o staym rozmiarze rwnym 256
       for (i = 0; i < height; i++)
       {
          for (j = 0; j < width; j++)
          {
           pixelIndex = (i * width) + j;
           alignedBitmapIndex = (i * xwidth) + j;
           red = (char) (javaBitmapData->pixels[pixelIndex] >> 8);
           green = (char)(javaBitmapData->pixels[pixelIndex] >> 16);
           blue = (char) (javaBitmapData->pixels[pixelIndex] >> 24);
           alpha = (char) (javaBitmapData->pixels[pixelIndex]);
 
           colorMatch = FALSE;
           for (k = 0; k < numColors; k++)
           {
             if ((colorTable + k)->rgbBlue == blue &&
                (colorTable + k)->rgbGreen == green &&
                (colorTable + k)->rgbRed == red)
              {
               bitmapIndex = alignedBitmapIndex +
                        xwidth * (height - (1 + (2 * i)));
               bitmapData[bitmapIndex] = (char) k;
               colorMatch = TRUE;
               break;
              }
           }
 
           if (!colorMatch)
           {
             bitmapIndex = alignedBitmapIndex +
                      xwidth * (height - (1 + (2 * i)));
             bitmapData[bitmapIndex] = (char) numColors;
             (colorTable + numColors)->rgbBlue = blue;
             (colorTable + numColors)->rgbGreen = green;
             (colorTable + numColors)->rgbRed = red;
             (colorTable + numColors)->rgbReserved = 0;
             numColors++;
           }
         }
       }
       (*pEnv)->ReleaseByteArrayElements(pEnv, data,
                                     javaData, JNI_ABORT);
       GlobalUnlock(handle);
 
       EmptyClipboard();
       SetClipboardData(format, handle);
       CloseClipboard();
     }
   }
 }

JNIEXPORT jintArray JNICALL
   Java_NativeExtendedClipboard_getFormats
   (JNIEnv *pEnv, jobject pObject)
 {
   jintArray returnFormats;
   int       localFormats[100];
   int       numFormats = 0;
   int       previousFormat = 0;
 
   if (OpenClipboard(NULL))
   {
     while (TRUE)
     {
       localFormats[numFormats] =
           EnumClipboardFormats(previousFormat);
       if (localFormats[numFormats] == 0)
         break;
 
       previousFormat = localFormats[numFormats];
       numFormats++;
     }
     returnFormats = (*pEnv)->NewIntArray(pEnv, numFormats);
     (*pEnv)->SetIntArrayRegion(pEnv, returnFormats, 0,
                                   numFormats, localFormats);
     CloseClipboard();
 
     return (returnFormats);
   }
   else
     return (NULL);
 }

 JNIEXPORT jbyteArray JNICALL Java_NativeExtendedClipboard_getBytes
   (JNIEnv *pEnv, jobject pObject, jint format)
 {
   HGLOBAL     handle;
   jbyteArray  returnData = NULL;
   int         BYTES_PER_INT = 4;
 
   BITMAPINFOHEADER  *bitmapHeader;
   int               colorTableSize = 0;
   RGBQUAD           *colorTable;
   unsigned int      colorTableIndex = 0;
   RGBQUAD           currentNativePixel;
   char              *bitmapData;
   int               width, height, xwidth;
   int               numPixels;
   int               pixelIndex, alignedBitmapIndex, bitmapIndex;
   int               i, j;
   unsigned char     alpha;
 
   if (OpenClipboard(NULL))
   {
     handle = GetClipboardData(format);
     if (handle != NULL)
     {
       if (format == CF_DIB)
       {
         bitmapHeader = (BITMAPINFOHEADER *) GlobalLock(handle);
         if (bitmapHeader->biSize == sizeof(BITMAPINFOHEADER))
         {
           width = bitmapHeader->biWidth;
           height = bitmapHeader->biHeight;
 
           if (width % sizeof(DWORD) == 0)
             xwidth = width;
           else
             xwidth = width + (sizeof(DWORD) -
                         (width % sizeof(DWORD)));
 
           numPixels = width * height;
 
           // pobiera informacje z tablicy kolorw
           colorTable = (RGBQUAD*) (((char*)bitmapHeader) +
                                   sizeof(BITMAPINFOHEADER));
           colorTableSize = 1 << bitmapHeader->biBitCount;
 
           bitmapData = (char*) (colorTable + colorTableSize);
           returnData = (*pEnv)->NewByteArray(pEnv,
                             sizeof(JavaBitmapData) +
                             (numPixels - 1) * sizeof(int));
 
           (*pEnv)->SetByteArrayRegion(pEnv, returnData,
                               0, BYTES_PER_INT, (char*)&width);
           (*pEnv)->SetByteArrayRegion(pEnv, returnData,
              1 * BYTES_PER_INT, BYTES_PER_INT, (char*)&height);
 
           pixelIndex = 2 * BYTES_PER_INT;
           alpha = 255;
           for (i = 0; i < height; i++)
           {
             for (j = 0; j < width; j++)
             {
               alignedBitmapIndex = (i * xwidth) + j;
               bitmapIndex = alignedBitmapIndex + xwidth *
                                       (height - (1 + (2 * i)));
 
               colorTableIndex =
                   (unsigned int) bitmapData[bitmapIndex];
               currentNativePixel = colorTable[colorTableIndex];
               (*pEnv)->SetByteArrayRegion(pEnv, returnData,
                             pixelIndex + 3, 1, (char*)&(alpha));
               (*pEnv)->SetByteArrayRegion(pEnv, returnData,
                             pixelIndex + 2, 1,
                             (char*)&(currentNativePixel.rgbRed));
               (*pEnv)->SetByteArrayRegion(pEnv, returnData,
                             pixelIndex + 1, 1,
                             (char*)&(currentNativePixel.rgbGreen));
               (*pEnv)->SetByteArrayRegion(pEnv, returnData,
                             pixelIndex, 1,
                             (char*)&(currentNativePixel.rgbBlue));
               pixelIndex += BYTES_PER_INT;
             }
           }
         }    item 41
         else
         {
           // nieznany format danych
           return (NULL);
         }
       }
       else
       {
         return (NULL);
       }
     }
     CloseClipboard();
   }
   return (returnData);
 }
