 import java.awt.*;
 import java.awt.event.*;
 import java.awt.datatransfer.*;
 
 public class ImageCanvas extends Canvas
                          implements ClipboardOwner, KeyListener
 {
    Clipboard       clipboard;
    Image           img;
    MediaTracker    tracker = new MediaTracker(this);
 
    public ImageCanvas ()
    {
       addKeyListener(this);
       clipboard = getToolkit().getSystemClipboard();
    }
 
    public void setImage (Image img)
    {
       tracker.addImage(img, 0);
       try
       {
          tracker.waitForAll();
       }
       catch (Exception e)
       {
          System.out.println("Error loading image: " +
                                          e.getMessage());
          return;
       }
 
       if (tracker.isErrorAny())
       {
          System.out.println("Error loading image.");
          return;
       }
 
       this.img = img;
       repaint();
    }
 
    public void paint (Graphics g)
    {
       if (img != null)
       {
          Dimension d = this.getSize();
          g.setColor(Color.white);
          g.fillRect(0,0, d.width, d.height); // to
          g.drawImage(img, 0, 0, img.getWidth(this),
                            img.getHeight(this), this);
       }
    }
 
    public void keyPressed (KeyEvent evt)
    {
       if (evt.isControlDown())
       {
          if (evt.getKeyCode() == KeyEvent.VK_A)  // kopiowanie
          {
             try
             {
                clipboard.setContents(
                            new TransferableImage(img), this);
             }
             catch (Exception e)
             {
                System.out.println(
                    "Error copying data. Error: " + e.getMessage());
             }
             evt.consume();
          }
          else if (evt.getKeyCode() == KeyEvent.VK_B) // wklejanie
           {
             Transferable clipboardData = clipboard.getContents(this);
 
             if (clipboardData != null)
             {
                try
                {
                   DataFlavor flavor =
                   new DataFlavor("image/gif;class=java.awt.Image");
 
                   if (clipboardData.isDataFlavorSupported(flavor))
                   {
                      this.setImage((Image)
                             clipboardData.getTransferData(flavor));
                   }
                }
                catch (Exception e)
                {
                   System.out.println(
                    "Error pasting data. Error: " + e.getMessage());
                }
             }
             evt.consume();
          }
       }
    }
 
    public void keyReleased (KeyEvent evt)  {   }
    public void keyTyped (KeyEvent evt)     {   }
 
    public void lostOwnership(Clipboard clipboard,
                                 Transferable contents) {   }
 
    public static void main (String args[])
    {
       Frame f = new Frame("Image Copy");
       f.setLayout(new GridLayout(0,1));
 
       ImageCanvas canvas1 = new ImageCanvas();
       ImageCanvas canvas2 = new ImageCanvas();
 
       canvas1.setImage(
         Toolkit.getDefaultToolkit().getImage("images/cloud.gif"));
       canvas2.setImage(
         Toolkit.getDefaultToolkit().getImage("images/sun.gif"));
 
       f.add(canvas1);
       f.add(canvas2);
 
       f.setSize(300,300);
       f.show();
    }
 }

class TransferableImage implements Transferable
 {
    DataFlavor  imageFlavor;
    Image       img;
 
    public TransferableImage (Image img) throws Exception
    {
       this.img = img;
       imageFlavor =
             new DataFlavor("image/gif;class=java.awt.Image");
    }
 
    public Object getTransferData(DataFlavor flavor)
                             throws UnsupportedFlavorException
    {
       if (imageFlavor.equals(flavor))
          return (img);
       else
          throw new UnsupportedFlavorException(flavor);
    }
 
    public DataFlavor[] getTransferDataFlavors()
    {
       DataFlavor[] flavors = new DataFlavor[1];
       flavors[0] = imageFlavor;
       return (flavors);
    }
 
    public boolean isDataFlavorSupported(DataFlavor flavor)
    {
       return (imageFlavor.equals(flavor));
    }
 }

