 import java.awt.*;
 import java.util.*;
 
 public class StateMonitor
 {
   // stany aktywne w danym momencie
    Vector states = new Vector();
   // odwzorowanie stanw na komponenty
    Hashtable active = new Hashtable();
   // odwzorowanie komponentw na liczniki
    Hashtable components = new Hashtable();
    
   public void activate (Component c, Object state)
   {
     Vector v = (Vector) active.get (state);
     if (v == null)
       v = new Vector();
     if (! v.contains (c))
       v.add (c);
     active.put (state, v);
   }
    
   public void addState (Object state)
   {
     if (! states.contains (state))
     {
       states.add (state);
       update (state, 1);
     }
   }
 
   public void removeState (Object state)
   {
     if (states.contains (state))
     {
       states.remove (state);
       update (state, -1);
     }
   }
 
   void update (Object state, int delta)
   {
     Vector v = (Vector) active.get (state);
     for (int i = 0; i < v.size(); i++)
     {
       int newCount = delta;
       Component c = (Component) v.get(i);
       Integer count = (Integer) components.get (c);
       if (count != null)
          newCount += count.intValue();
       if (newCount == 0)
          c.setEnabled (false);
       else if (newCount == 1)
          c.setEnabled (true);
       components.put (c, new Integer (newCount));
     }
   }
 }
