 import java.awt.event.*;
 import java.util.*;
 import javax.swing.*;
 
 public class ListViewer extends JFrame
 implements ActionListener
 {
    Vector data;
    int element;
    JPanel buttons;
    StateMonitor sm;
    
    private static String PREV_ELEMENTS = "prev";
    private static String NEXT_ELEMENTS = "next";
 
    public ListViewer (Vector data)
    {
       this.data = data;
       sm = new StateMonitor();

       buttons = new JPanel();
       addButton ("First",    PREV_ELEMENTS);
       addButton ("Previous", PREV_ELEMENTS);
       addButton ("Next",     NEXT_ELEMENTS);
       addButton ("Last",     NEXT_ELEMENTS);
       getContentPane().add (buttons);

       if (data.size() > 1)
           sm.addState (NEXT_ELEMENTS);
       actionPerformed
          (new ActionEvent (this, 0, "First"));
       pack();
       show();
    }
 
    void addButton (String label, String state)
    {
       JButton btn = new JButton (label);
       btn.setEnabled (false);
       btn.addActionListener (this);
       sm.activate (btn, state);
       buttons.add (btn);
    }
 
    public void actionPerformed (ActionEvent e)
    {  
       String cmd = e.getActionCommand();
       int size = data.size();

       if (cmd.equals ("First"))
          element = 0;
       else if (cmd.equals ("Previous"))
          element;
       else if (cmd.equals ("Next"))
          element++;
       else if (cmd.equals ("Last"))
          element = size - 1;

       if (element == 0)
           sm.removeState (PREV_ELEMENTS);
       else
           sm.addState (PREV_ELEMENTS);
       if (element == size - 1)
           sm.removeState (NEXT_ELEMENTS);
       else
           sm.addState (NEXT_ELEMENTS);

       setTitle ((element + 1) + " of " + size);
    }
    
    public static void main (String[] args)
    {
       Vector v = new Vector();
       for (int i = 0; i < 3; i++)
          v.add (new Object());
       new ListViewer (v);
    }
 }
