 import java.util.Vector;
 import javax.swing.event.DocumentEvent;
 import javax.swing.text.*;
 
 public abstract class ValidationAdapter
 implements Validator
 {
    Vector listeners = new Vector();
    boolean wasValid = false;
    
    public abstract boolean isValid (Object value);
    
    public boolean validate (Object value)
    {
        boolean isValidNow = isValid (value);
       if (isValidNow != wasValid) // stan uleg zmianie
       {
          fireChangedEvent (value, isValidNow);
          wasValid = isValidNow;
       }
       return (isValidNow);
    }
    
    // implementuje DocumentListener
    public void removeUpdate  (DocumentEvent e)
    {
       validateDocument (e.getDocument());
    }
    public void changedUpdate (DocumentEvent e)
    {
       validateDocument (e.getDocument());
    }
    public void insertUpdate  (DocumentEvent e)
    {
       validateDocument (e.getDocument());
    }
 
    void validateDocument (Document doc)
    {
      try
      {
        validate (doc.getText (0, doc.getLength()));
      }
      catch (BadLocationException e) { }
    }
 
    public void addStatusListener (StatusListener l)
    {
       listeners.add (l);
    }
    public void
       removeStatusListener (StatusListener l)
    {
       listeners.remove (l);
    }
    
    public void fireChangedEvent (Object value,
                                  boolean status)
    {
       StatusEvent event =
         new StatusEvent (this, value, status);
       for (int i = listeners.size()-1; i >= 0; i)
       {
         StatusListener sl =
            (StatusListener) listeners.elementAt(i);
         sl.stateChanged (event);
       }
    }     
 }
