 import java.awt.event.*;
 import java.awt.*;
 import java.util.Vector;
 
 public class AvoidFlicker extends Panel
 implements MouseMotionListener, MouseListener
 {
    Vector lines = new Vector();
    int x, y;
    
    public AvoidFlicker1()
    {
       addMouseMotionListener (this);
       addMouseListener(this);
    }
 
    public void mouseClicked  (MouseEvent e) { }
    public void mouseEntered  (MouseEvent e) { }
    public void mouseExited   (MouseEvent e) { }
    public void mouseMoved    (MouseEvent e) { }
    public void mouseReleased (MouseEvent e) { }
 
    public void mousePressed  (MouseEvent e)
    {
       x = e.getX();
       y = e.getY();
    }
    
    // rysuje odcinek gdy uzytkownik przesuwa mysz
    public void mouseDragged (MouseEvent e)
    {
       lines.addElement
         (new Rectangle (x, y, e.getX(), e.getY()));
       x = e.getX(); y = e.getY();
       repaint();
    }
 
    public void paint (Graphics g)
    {
       // rysuje to (kolorowe paski)
       Dimension size = getSize();
       for (int y = 0; y < size.height; y += 2)
       {
          int blue = 255 - (y % 256);
          Color color = new Color (128, 128, blue);
          g.setColor (color);
          g.fillRect (0, y, size.width, 2);
       }
 
       // rysuje pierwszy plan (odcinki)
       g.setColor (Color.black);
       int numberOfPoints = lines.size();
       for (int i = 0; i < numberOfPoints; i++)
       {
          Rectangle r =
            (Rectangle) lines.elementAt (i);
          g.drawLine (r.x, r.y, r.width, r.height);
       }
       super.paint (g); // dla kontenera
    }
    
    public static void main (String[] args)
    {
       AvoidFlicker panel = new AvoidFlicker();
       Frame f = new Frame ("Avoiding Flicker");
       f.add ("Center", panel);
       f.setSize (300, 300);
       f.show();
    }
 }
