/** VerticalFlowLayout.java */
 import java.awt.*;
 
 public class VerticalFlowLayout implements LayoutManager
 {
     int iVerticalGap;
 
     public VerticalFlowLayout()
     {
         iVerticalGap = 2;
     }
 
     public VerticalFlowLayout(int vGap)
     {
         iVerticalGap = vGap;
     }
 
     public void addLayoutComponent(String name, Component comp)
     {
         // Implementacja nie jest konieczna
         // poniewa nie uywamy nazw do rnicowania komponentw.
     }
 
     public void removeLayoutComponent(Component comp)
     { }
 
     public Dimension preferredLayoutSize(Container parent)
     {
         return getLayoutSize(parent, false);
     }
 
     public Dimension minimumLayoutSize(Container parent)
     {
         return getLayoutSize(parent, true);
     }
 
     private Dimension getLayoutSize(Container parent, boolean min)
     {
         int iNumComponents = parent.getComponentCount();
         Dimension outDim = new Dimension(0,0);
         for (int i=0; i < iNumComponents; i++)
         {
             Component c = (Component) parent.getComponent(i);
             Dimension cDim = (min) ? c.getMinimumSize() :
                                      c.getPreferredSize();
             // szeroko bdzie rwna szerokoci najwiekszego komponentu
             outDim.width = Math.max (cDim.width, outDim.width);
             outDim.height += cDim.height;
             if (i != 0)
                 outDim.height += iVerticalGap;
         }
         Insets border = parent.getInsets();
         outDim.width += border.left + border.right;
         outDim.height += border.top + border.bottom;
         return outDim;
     }
 
     public void layoutContainer(Container parent)
     {
         Dimension available = parent.getSize();
         Dimension required = preferredLayoutSize (parent);
         boolean useMinimum = required.height < available.height;
         Insets insets = parent.getInsets();
         final int x = insets.left;
         int y = insets.top;
         final int w = Math.max (available.width, required.width);
         final int excessHeight = available.height - required.height;
 
         int count = parent.getComponentCount();
         for (int i = 0; i < count; i++)
         {
          Component comp = parent.getComponent (i);
          if (comp.isVisible())
          {
               int h = (useMinimum) ? comp.getMinimumSize().height :
                                      comp.getPreferredSize().height;
               if (excessHeight > 0)
                  h += (h * excessHeight / required.height); 
               comp.setBounds (x, y, w, h);
               y += (h + iVerticalGap);
          }
         }
     }
 }
